proc LoadDefaults {} {
	global indef fmesg
	set fdef [open "a.in"]
	gets $fdef indef
	close $fdef
	set fdef [open "mes.in"]
	gets $fdef fmesg
	close $fdef
}	

proc InSelect {} {
	global cin ain vin indef
	message .min -text "Select b.in" -width 80
	message .min1 -text "Save b.in to:" -width 80
	entry .ein -relief sunken -width 12
	set fin [open "files.in"]
	set fname ""
	set iin 0 
	while { [string compare $fname "*"] != 0 } {
		set ain($iin) $fname
		incr iin
		gets $fin fname
	}
	close $fin

	if { $iin > 0 } { set iin [expr $iin - 1] }
	menubutton .pin -menu .pin.m -indicatoron 1 -relief ridge -textvariable cin -width 12
	menu .pin.m
	for {set i 1} {$i<=$iin} {incr i 1} {
		.pin.m add radiobutton -label $ain($i) -variable vin -value $i -command {
			set cin $ain($vin)
			.ein delete 0 100
			.ein insert 0 $cin
		}
		if { [string compare $indef $ain($i)]==0} { 
			set vin $i
			set cin $ain($vin)
			.ein insert 0 $cin
		}
	}
	place .min -x 0   -y 0
	place .pin -x 90  -y 0
	place .min1 -x 230 -y 0
	place .ein -x 320 -y 0
}

proc InLearn {} {
	global cler aler vler lerdef
	message .mler -text "Sel learn.dat" -width 80
	entry .eler -relief sunken -width 8
	set fler [open "learn.in"]
	set fname ""
	set iler 0 
	while { [string compare $fname "*"] != 0 } {
		set aler($iler) $fname
		incr iler
		gets $fler fname
	}
	close $fler

	if { $iler > 0 } { set iler [expr $iler - 1] }
	menubutton .pler -menu .pler.m -indicatoron 1 -relief ridge -textvariable cler -width 8
	menu .pler.m
	for {set i 1} {$i<=$iler} {incr i 1} {
		.pler.m add radiobutton -label $aler($i) -variable vler -value $i -command {
			set cler $aler($vler)
			.eler delete 0 100
			.eler insert 0 $cler
		}
	}
	place .mler -x 0   -y 280
	place .pler -x 90  -y 280
	place .eler -x 180 -y 280
}



proc InPaw {} {
	global cpaw apaw vpaw indef
	message .mpaw -text "PAW file:" -width 80
	set fpaw [open "paw.in"]
	set fname ""
	set ipaw 0 
	while { [string compare [string index $fname 0] "*"] != 0 } {
		set apaw($ipaw) $fname
		incr ipaw
		gets $fpaw fname
	}
	close $fpaw

	if { $ipaw > 0 } { set ipaw [expr $ipaw - 1] }
	menubutton .ppaw -menu .ppaw.m -indicatoron 1 -relief ridge -textvariable cpaw -width 12
	menu .ppaw.m
	for {set i 1} {$i<=$ipaw} {incr i 1} {
		.ppaw.m add radiobutton -label $apaw($i) -variable vpaw -value $i -command {
			set cpaw $apaw($vpaw)
		}
	}
	place .mpaw -x 10   -y 370
	place .ppaw -x 100  -y 370
}

proc InOut {} {
	global cout aout vout indef
	message .mout -text "OUT file" -width 80
	set fout [open "out.in"]
	set fname ""
	set iout 0 
	while { [string compare $fname "*"] != 0 } {
		set aout($iout) $fname
		incr iout
		gets $fout fname
	}
	close $fout

	if { $iout > 0 } { set iout [expr $iout - 1] }
	menubutton .pout -menu .pout.m -indicatoron 1 -relief ridge -textvariable cout -width 12
	menu .pout.m
	for {set i 1} {$i<=$iout} {incr i 1} {
		.pout.m add radiobutton -label $aout($i) -variable vout -value $i -command {
			set cout $aout($vout)
		}
	}
	place .mout -x 250   -y 370
	place .pout -x 340  -y 370
}



wm geometry . 500x550+200+100
wm resizable . 0 0
wm title .   DarkSetup

#button .bin -text "Run 

LoadDefaults
InSelect
InPaw
InOut
InLearn

button .din -text "Delete" -command { 
	set fout [open "runner.bat" w]
	puts $fout "(rm arc/in/$cin)2>/dev/null" 
	puts $fout "exit"
	close $fout
	exit 1
}
button .dok -text "Run"    -command { 
	set fout [open "runner.bat" w]
	puts $fout "ani arc/in/$cin arc/in/[.ein get]" 
	puts $fout "exit"
	close $fout
	set fout [open "a.in" w]
	puts $fout "[.ein get]"
	close $fout
	exit 1
}
place .din -x 100 -y 40
place .dok -x 300 -y 40 

message .rmes -text "View results:" -background blue -foreground yellow -width 200
message .omes -text "$fmesg" -width 200 -foreground red
button .rpaw -text "Run PAW++" -command { 
	set fout [open "runner.bat" w]
	puts $fout "rpaw.bat" 
	puts $fout "exit"
	close $fout
	exit 1
}
button .rout -text "View b.out" -command { 
	set fout [open "runner.bat" w]
	puts $fout "nedit b.out &" 
	puts $fout "exit"
	close $fout
	exit 1
}
button .rsys -text "View b.sys" -command { 
	set fout [open "runner.bat" w]
	puts $fout "nedit b.sys &" 
	puts $fout "exit"
	close $fout
	exit 1
}
button .rcmz -text "Run CMZ"   -command { 
	set fout [open "runner.bat" w]
	puts $fout "cmz" 
	puts $fout "exit"
	close $fout
	exit 1
}
place .rmes -x 100 -y 80
place .rpaw -x 50 -y 120 
place .rout -x 150 -y 120
place .rsys -x 250 -y 120 
place .rcmz -x 350 -y 120
place .omes -x 200 -y 80

message .msg1 -text "Save output to archive:" -foreground yellow -background blue -width 300
place .msg1 -x 100 -y 165

message .mout1 -text "File to Save <b.out>" -width 120
message .mout2 -text "Comment:" -width 60
entry .eout1 -relief sunken -width 10
entry .eout2 -relief sunken -width 10
button .bout1 -text "Save" -command { 
	set fout [open "runner.bat" w]
	puts $fout "echo \"********************************\" >>arc/out/[.eout1 get]"
	puts $fout "echo \"******** [.eout2 get] **********\" >>arc/out/[.eout1 get]"
	puts $fout "echo \"********************************\" >>arc/out/[.eout1 get]"
	puts $fout "cat b.out >>arc/out/[.eout1 get]" 
	puts $fout "exit"
	close $fout
	exit 1
}
place .mout1 -x 0 -y 200
place .eout1 -x 160 -y 200
place .mout2 -x 240 -y 200
place .eout2 -x 320 -y 200
place .bout1 -x 400 -y 196
 
message .mpaw1 -text "Save PAW output" -width 120
entry .epaw1 -relief sunken -width 33
button .bpaw1 -text "Save" -command { 
	set fout [open "runner.bat" w]
	puts $fout "cp b.in arc/paw/[.epaw1 get]."
	puts $fout "cp b.hbook arc/paw/[.epaw1 get].hbook" 
	puts $fout "exit"
	close $fout
	exit 1
}
place .mpaw1 -x 0 -y 240
place .epaw1 -x 160 -y 240
place .bpaw1 -x 400 -y 236

button .l1 -text "Restore" -command {
	set fout [open "runner.bat" w]
	puts $fout "(cp arc/learn/[.eler get] learn.dat)2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1
}
button .l2 -text "Save" -command {
	set fout [open "runner.bat" w]
	puts $fout "(cp learn.dat arc/learn/[.eler get])2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1

}
button .l3 -text "Delete" -command {
	set fout [open "runner.bat" w]
	puts $fout "(rm arc/learn/[.eler get])2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1
}
place .l1 -x 327 -y 276
place .l2 -x 400 -y 276 
place .l3 -x 262 -y 276

message .mes -text "View archived results:" -foreground yellow -backgroun blue -width 200
button .paw -text "View PAW Arc" -command { 
	set fout [open "runner.bat" w]
	puts $fout "(cp b.in b.in.save)2>/dev/null"
	puts $fout "(cp b.hbook b.hbook.save)2>/dev/null"
	puts $fout "(cp arc/paw/$cpaw b.in)2>/dev/null"
	puts $fout "(cp arc/paw/$cpaw\hbook b.hbook)2>/dev/null"
	puts $fout "rpaw.bat" 
	puts $fout "(cp b.hbook.save b.hbook)2>/dev/null"
	puts $fout "(cp b.in.save b.in)2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1
}
button .out -text "View OUT Arc" -command { 
	set fout [open "runner.bat" w]
	puts $fout "nedit arc/out/$cout &" 
	puts $fout "exit"
	close $fout
	exit 1
}
button .dpaw -text "Delete PAW Arc" -command { 
	set fout [open "runner.bat" w]
	puts $fout "(rm arc/paw/$cpaw)2>/dev/null"
	puts $fout "(rm arc/paw/$cpaw\hbook)2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1
}
button .dout -text "Delete OUT Arc" -command { 
	set fout [open "runner.bat" w]
	puts $fout "(rm arc/out/$cout)2>/dev/null"
	puts $fout "exit"
	close $fout
	exit 1
}
place .mes -x 100 -y 330
place .paw -x 10 -y 410 
place .dpaw -x 120 -y 410
place .out -x 260 -y 410
place .dout -x 370 -y 410

button .ex -text "EXIT" -command { exit 0 }
place .ex -x 220 -y 490


message .msg -text "Interface by DarkSoft" -foreground red  -width 150 -relief groove 
.msg configure -font *-times-medium-i-*-12-*
place .msg -x 375 -y 520

	
