#define WritePath "/home/data"
char filnam[80];		// Current File we must write
unsigned int BufPos=0;		// Position in records buffer
double kg;
unsigned char TitleWrited=0;	// Flag: is title alredy writed to file

void WrTitle(FILE *f)
{
    char *s=longdate();
    fprintf(f,"%s Internal time  = %u sec  Barometer channel = %u\n",s,tint,nbar);
    free(s);    
}

FILE *Openfile()
{
    FILE *f;
    time_t t=time(NULL);
    struct tm *tms=gmtime(&t);
    sprintf(filnam,"%s/%u%s%s.%s",wrpath,tms->tm_year+1900,lz(tms->tm_mon+1),lz(tms->tm_mday),iname);
    f=fopen(filnam,"r");
    if (f)
    {
	fclose(f);
	f=fopen(filnam,"a+");
	if (!TitleWrited) 
	{
	    WrTitle(f);
	    TitleWrited=1;
	}
    }
    else 
    {
	f=fopen(filnam,"w");    
	if (!f) {
	    fprintf(stderr,"Can't write file... \n Probably directory doesn't exist...
	    or disk is full!\n");
	    exit(1);
	}
	WrTitle(f);
	TitleWrited=1;
    }
    return f;
}

void SaveData(FILE *f,unsigned short int n)
{
    unsigned short int i,j;
    unsigned long utmp;
    
    for (i=0;i<=n;i++)
    {
	fprintf(f,"%s  ",tbuf[i]);
	for (j=0;j<nch;j++)
	{
	    utmp=Round(kg*dbuf[i][j+11]);
//	    if (utmp>9999) utmp=9999;
	    fprintf(f,"%5.u ",utmp);
	}
	fprintf(f,"\n");
    }
    fclose(f);
}

void WriteFile()
{
    FILE *f;			// Descriptor on file processing
    void *tmp;			// Temporary pointer

	    // New Day Started ( If BufPos=0 All OK )
    if ((tbuf[BufPos][0]<tbuf[0][0])||((tbuf[BufPos][0]==tbuf[0][0])&&(tbuf[BufPos][1]<tbuf[0][1])))
    {
	    // No need for file opening because BufPos>0
        f=fopen(filnam,"a+");
        SaveData(f,BufPos-1);

	tmp=(void*)dbuf[0];
	dbuf[0]=dbuf[BufPos];
	dbuf[BufPos]=(unsigned short int*)tmp;

	tmp=(void*)tbuf[0];
	tbuf[0]=tbuf[BufPos];
	tbuf[BufPos]=(char*)tmp;
	
	BufPos = 0;
    }
        // Buffer Full
    if (BufPos+1 == tfint)
    {
        f=Openfile(); 
        SaveData(f,BufPos); 
        BufPos = 0;
    }
    else BufPos++;
}
