#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include "stc.h"

extern int errno;

static struct Clients *FirstClient=NULL;
static int dsock;

void AddClient(struct sockaddr_in *nc)
{
    struct Clients *ctmp,*ctmplast=NULL;
    int nc_ipaddr;			// New clients IP
    
        // Search if ip alredy in queue
    nc_ipaddr=nc->sin_addr.s_addr;

    ctmp=FirstClient;
    while ((ctmp)&&(ctmp->ipaddr!=nc_ipaddr)) 
    {
	ctmplast=ctmp;
	ctmp=ctmp->Next;
    }

    if (ctmp) 
    {
	ctmp->timeout=time(NULL);
	return;
    }
	
	// New client
    ctmp=(struct Clients*)malloc(sizeof(struct Clients));
    if (ctmplast)
	ctmplast->Next=ctmp;
    else 
	FirstClient=ctmp;
    
    ctmp->ipaddr=nc_ipaddr;
    ctmp->addr=nc;
    ctmp->timeout=time(NULL);
    ctmp->Prev=ctmplast;
    ctmp->Next=NULL;
}


void stcSend(void *buf, unsigned long bufsize)
{
    int err;
    time_t curtime;
    struct Clients *ctmp=FirstClient;
    
    curtime=time(NULL);
    while (ctmp)
    {
	    // Clearing lost clients
	if ((curtime-ctmp->timeout)>ClientTimeout)
	{
	    free(ctmp->addr);
	    if (ctmp==FirstClient) FirstClient=FirstClient->Next;
	    if (ctmp->Prev) ctmp->Prev->Next=ctmp->Next;
	    if (ctmp->Next) 
	    {
		ctmp->Next->Prev=ctmp->Prev;
		ctmp=ctmp->Next;
		free(ctmp->Prev);
	    }
	    else
	    {
		free(ctmp);
		ctmp=NULL;
	    }
	}
	    // Sending
	else
	{
	    err=sendto(dsock,buf,bufsize,MSG_DONTWAIT,
		(struct sockaddr*)ctmp->addr,sizeof(struct sockaddr_in));
	    if (err<0)
		fprintf(stderr,"Can't send message to client. Error %lu\n",errno);
	    ctmp=ctmp->Next;
	}
    }
}

static struct sockaddr_in *clientaddr;

void stcInitialise()
{
    struct sockaddr_in servaddr;
    dsock=socket(PF_INET,SOCK_DGRAM,IPPROTO_UDP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open socket!");
	exit(1);
    }
	// Making socket NON_BLOCK
    fcntl(dsock,F_SETFL,O_NONBLOCK);

	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(port);
    servaddr.sin_addr.s_addr=htonl(INADDR_ANY);
    
    if (bind(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in)))
    {
	fprintf(stderr, "Can't bind socket on port %lu\n",port);
	exit(1);
    }
    clientaddr=(struct sockaddr_in*)malloc(sizeof(struct sockaddr_in));
}

void stcLoop()
{
    int err;
    unsigned char idmsg;
    int clientaddrsize=sizeof(struct sockaddr_in);
    
    err=recvfrom(dsock,(void*)&idmsg,1,0,
        (struct sockaddr*)clientaddr,&clientaddrsize);
	
    if ((err>0)&&(idmsg==0xD0))
    {
        fprintf(stderr, "Request from: %s\n",
		    inet_ntoa(clientaddr->sin_addr.s_addr));
        AddClient(clientaddr);
        clientaddr=(struct sockaddr_in*)malloc(sizeof(struct sockaddr_in));
    }

}

void stcRelease()
{
    struct Clients *ctmp;
    free(clientaddr);
	// Release clients
    ctmp=FirstClient;
    if (ctmp)
    {
	while (ctmp->Next)
	{
	    free(ctmp->addr);
	    ctmp=ctmp->Next;
	    free(ctmp->Prev);
	}
	free(ctmp->addr);
	free(ctmp);
    }
    FirstClient=NULL;
}
