unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Spin, ExtCtrls, Unit1, Unit2, DB, Grids, DBGrids,
  ADODB, DateUtils, RegExpr;

type
  TForm3 = class(TForm)
    ADODataSet1: TADODataSet;
    DataSource1: TDataSource;
    GroupBox1: TGroupBox;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    SpinEdit1: TSpinEdit;
    GroupBox2: TGroupBox;
    RadioGroup2: TRadioGroup;
    BegDate: TDateTimePicker;
    Label1: TLabel;
    T: TLabel;
    EndDate: TDateTimePicker;
    TimeL: TDateTimePicker;
    GroupBox3: TGroupBox;
    DBGrid1: TDBGrid;
    Splitter1: TSplitter;
    GroupBox4: TGroupBox;
    Edit2: TEdit;
    Button2: TButton;
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure DBGrid1CellClick(Column: TColumn);
    procedure BegDateChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

//   Edit2.Text
procedure QueryUpd;
var
  s1,s2: string;
  s:string;
  i:byte;
begin

  with Form3 do begin
    if RadioGroup1.ItemIndex = 0 then
      s := inttostr(SpinEdit1.Value)
    else
      s := ''''+Edit1.Text+'''';
    s := s + ',';
    case RadioGroup2.ItemIndex of
     0:
      begin
        s := s + '1980-01-01 00:00:00, ';
        s1 := '';
        DateTimeToString(s1,'yyyy-MM-dd HH:mm:ss',Tomorrow);
        s := s + s1;// + '''';
      end;
     1:
      begin
        s1 := '';
        DateTimeToString(s1,'yyyy-MM-dd HH:mm:ss',BegDate.DateTime);
        s := s +  s1 + ',';
        DateTimeToString(s1,'yyyy-MM-dd HH:mm:ss',EndDate.DateTime);
        s := s + s1;// + '''';
      end;
     2:
      begin
        DateTimeToString(s1,'HH:mm:ss',TimeL.DateTime);
        s1 :='0000-00-00 '+ s1 + '.000,0000-00-00 00:00:00.000';
        s := s+s1;
      end;
    end;
    Edit2.Text := 'TAG:R,' + s;
  end;

end;

// ID/ 
procedure TForm3.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0 :
      begin
        Edit1.Enabled := False;
        SpinEdit1.Enabled := True;
      end;
    1 :
      begin
        Edit1.Enabled := True;
        SpinEdit1.Enabled := False;
      end;
  end;
end;

//
procedure TForm3.Button1Click(Sender: TObject);
begin

  QueryUpd;

end;

//  /
procedure TForm3.RadioGroup2Click(Sender: TObject);
begin
  case RadioGroup2.ItemIndex of
   0:
    begin
      BegDate.Enabled := False;
      EndDate.Enabled := False;
      TimeL.Enabled := False;
    end;
   1:
    begin
      BegDate.Enabled := True;
      EndDate.Enabled := True;
      TimeL.Enabled := False;
    end;
   2:
    begin
      BegDate.Enabled := False;
      EndDate.Enabled := False;
      TimeL.Enabled := True;
    end;
   end;
  QueryUpd;

end;

procedure TForm3.Button2Click(Sender: TObject);
begin

  QueryUpd;
  Form2.Edit1.Text := Edit2.Text;
  Form3.Close;

end;

procedure TForm3.FormActivate(Sender: TObject);
var
  str: TStringList;
  re: TRegExpr;
begin
   BegDate.Enabled := False;
   EndDate.Enabled := False;
   TimeL.Enabled := False;

   str := TStringList.Create();
   Form1.GetClassDatabases(Form2.Caption, str);

   re := TRegExpr.Create;
   re.Expression := 'Initial Catalog=[^;]+;';
   ADODataSet1.ConnectionString := re.Replace(Form1.Edit1.Text,'Initial Catalog=' + str.Strings[0] + ';',true);
   ADODataSet1.CommandText := 'SELECT ValueID, ValueName FROM [dbo].[Archive] ORDER BY ValueID ASC';

   re.Destroy;
   str.Destroy();

   ADODataSet1.Active:=True;
end;

procedure TForm3.DBGrid1CellClick(Column: TColumn);
begin

  SpinEdit1.Value:=DBGrid1.SelectedField.AsInteger;
  Edit1.Text:=Trim(DBGrid1.Fields[1].AsString);
  QueryUpd;

end;

procedure TForm3.BegDateChange(Sender: TObject);
begin

  QueryUpd;

end;


end.
