require 'socket'
require 'fileutils'

require 'RMagick'
include Magick

require 'cameralink/cameralink'

FAST = false

class Camera < CameraLink::Reader
    attr_accessor :public
    attr_accessor :max_width
    attr_accessor :max_height
    attr_accessor :width
    attr_accessor :height
    attr_accessor :exposure
    attr_accessor :frame_rate
    attr_accessor :capture
    attr_accessor :trigger

    def initialize()
	# Getting parameters from camera
	#@max_width = Integer(get('Window.W.Max'))
	#@max_height = Integer(get('Window.H.Max'))
	@max_width, @max_height = 1280, 1024
	
	if ((@max_width <= 0) or (@max_height <= 0)) then 
	    raise('Camera communication is failed')
	end

	@width, @height = @max_width, @max_height
	
	if FAST then
	    @frame_rate = 500
	    @exposure = 2
	    @trigger = 1
	else
	    set('Window.W', @width)
	    set('Window.H', @height)
	    
	    @trigger = get_integer('Trigger.Source', 0)
	    if (@trigger != 0) && (@trigger != 2) then 
		@trigger = set('Trigger.Source', 0)
	    end

	    if @trigger > 0 then
		@frame_rate = nil
	    else
		@frame_rate = get_integer('FrameRate', 10)
	    end
	    
	    @exposure = Float(get('ExposureTime'))
	end

	@display_fps = 25	
	@display_mode = 0
#	@trigger = 0

	@catpure = 1

	@display_proc = lambda { |w,h,d| }
	@status_proc = lambda { |t| }
	
	@set_request = Array.new
	
	@preallocate = nil
	
	FileUtils::mkdir_p("saved_camera_images")

	super()
    end
    
    def set_procs(status_proc, display_proc)
	@display_proc = display_proc
	@status_proc = status_proc
    end
    

    def get(val)
	s = UNIXSocket.open('/tmp/pfserver.socket')
	s.print(val)
	res = s.gets()
	s.close
	return res
    end
    
    def get_integer(val, min) 
	res = get(val)
	if res =~ /^#(\d+)/ then
	    value = Integer($1);
	else
	    value = Integer(Float(res));
	end
	raise('Camera communication is failed') if value < min 
	return value
    end

    def set(val, value)
	s = UNIXSocket.open('/tmp/pfserver.socket')
	s.print(val + ' ' + String(value))
	res = s.gets()
	s.close
	return res
    end

    # s.get for some reason is crashing if called from GTK callback
    def set2(val, value)
	s = UNIXSocket.open('/tmp/pfserver.socket')
	s.print(val + ' ' + String(value))
	s.close
    end

    def open()
	@running = true
	@reader_open = false
	@reader_thread = Thread.new {
	    while @running and not @reader_open
		sleep 0.0001
	    end
	    
	    geometry = Magick::Geometry.new(@width,@height,nil,nil,Magick::AspectGeometry)
	    
	    if @trigger > 0 then
	        next_display = Time.now
		next_status = next_display + 1
		func = :threaded_run
	    else
		next_status = @frame_rate
		func = :run
	    end

	    #safe_run(@running) { |id, data|
	    #run(@running) { |id, data|
	    send(func, @running) { |id, data|
		if ((id < 0) or (not data)) then next; end
		
		@lost_frames += id - @current_frame - 1

		#if (id - @current_frame - 1) > 10
		#    puts id, id - @current_frame - 1
		#end

		@current_frame = id
		
		time = Time.now
		
		if (case @trigger; when 0: id > next_status; else time > next_status; end) then
		    if (@frame_rate) then
			msg = sprintf("FPS/Expected: %i, FPS/Measured: %i, Dropped Frames: %i", @frame_rate, @frames, @lost_frames)
		    else
			msg = sprintf("FPS/Expected: triggered, FPS/Measured: %i, Dropped Frames: %i", @frames, @lost_frames)
		    end
		    
		    if (@capture) then
			msg += sprintf(", Captured: %i (%i MB)", @image_frames.length, @image_frames.length * @width * @height / 1024 / 1024)
		    end
		    
		    @status_proc.call(msg, false)
		    
		    while @set_request.length > 0
			@set_request.pop.call
		    end
		    
		    @frames = 0
		    next_status = (@trigger > 0)?(time + 1):(id + @frame_rate - 1)
		    @lost_frames = 0
		end

		if (case @trigger; when 0: ((@display_mode > 0) and (id%@display_mode == 0)); else time > next_display; end) then
		    @display_proc.call(@width, @height, data)
		    next_display = (@display_mode>0)?time + (1.0 / @display_fps):time if (@trigger > 0)
		end
		
		if (@capture) then
		    if (@capture_storage > 0) then
			img = Image.from_blob(data) {
			    self.format = "GRAY"
	    		    self.depth = 8
			    self.size = geometry
			}[0]
			
			@capture_frame += 1
			img.write(sprintf("saved_camera_images/%s/PIC%09i.tif", @session, @capture_frame))
			img.destroy!
		    else 
			@images.push(String.new(data))
		    end
		    
		    @image_frames.push(id)
		    
		    if (time > @stop_capture)
		    	GC.enable if @capture_storage == 0

			@capture = false
			@capture_session = @session
			@capture_width = @width
			@capture_height = @height
			@stop_action.call()
		    end
		end

		@frames += 1
	    }
	}
	super(@width, @height)
	
	@frames = 0
	@lost_frames = 0
	@current_frame = 0
	@reader_open = true
    end
    
    def close()
	stop
	if @running then
	    @running = false
	    @reader_thread.join
	end
	super()
    end
    
    def display_fps=(value)
	@display_fps = value
	@display_mode = (@frame_rate / value).round if ((@display_mode > 1) and (@frame_rate))
    end
    
    def display_mode=(value)
	@display_mode = case value 
	    when 0: @frame_rate?((@frame_rate / @display_fps).round):2
	    when 1: 1
	    when 2: 0
	end
    end
    
    def camera_mode()
	@trigger
    end
    
    def camera_mode=(value)
	close
	
	@status_proc.call("Changing camera mode...", true)
	@trigger = value * 2
	set('Trigger.Source', @trigger)
	
	if @trigger > 0 then
	    @frame_rate = nil
	else
	    @frame_rate = get_integer('FrameRate', 10)
	    @display_mode = (@frame_rate / @display_fps).round if @display_mode > 1
	end

	
	open
=begin
	@set_request.push(lambda {
	    trigger = set('Trigger.Source', value * 2)
	    @trigger = Integer(trigger[1..(trigger.length-1)])
	    if @trigger == 0 then
		@frame_rate = get_integer('FrameRate', 10)
		@display_mode = (@frame_rate / @display_fps).round if @display_mode > 1
	    else
		@frame_rate = nil
	    end
	})
=end
    end
    
    def exposure=(value)
	@set_request.push(lambda {
	    @exposure = set('ExposureTime', value)
	    @frame_rate = get_integer('FrameRate', 10) if @trigger == 0
	})
    end
    
    def set_resolution(res) 
	close
	
	@status_proc.call("Changing resolution...", true)
	@width, @height = res
	
	set('Window.W', @width);
	set('Window.H', @height);
	
	if @trigger == 0 then
	    @frame_rate = get_integer('FrameRate', 10)
	    @display_mode = (@frame_rate / @display_fps).round if @display_mode > 1
	end
	
	open
    end
    
    def start_capture(storage, duration, &stop_action)
	if storage == 0 and @frame_rate then
	    size = @width * @height * @frame_rate * duration
	    if (100 + 1.02 * size) > $freemem then
		storage = 1
	    end
	end
	
	@images = (storage>0)?nil:Array.new()
	@image_frames = Array.new()
	
	if storage == 0 then
	    #GC.start may cause frame lose, it somehow prevented by calling it after GUI initialization, but still it is possible
	    GC.start
	
	    GC.disable
	end
	
	time = Time.now
	#@session = time.to_i
	@session = sprintf("%02i%02i%02i_%02i%02i%02i", time.year, time.month, time.day, time.hour, time.min, time.sec)
	FileUtils::mkdir_p("saved_camera_images/" + @session) if (storage > 0)

	@stop_capture = Time.now + duration
	@stop_action = stop_action
	@capture_storage = storage
	@capture_frame = 0
	@capture = true
	
	return storage
    end
    
    def stop_capture()
	@stop_capture = Time.now
    end

    def replay()
	yield(@capture_width, @capture_height, @images?@images:@capture_session, @image_frames)
    end
end
