#!/usr/bin/ruby
require 'fileutils'

require 'gtkglext'
require 'libglade2'

require 'RMagick'
include Magick

class Progress < Gtk::ProgressBar
 def initialize(parent, length, title)
    @length = length
    @iteration = 0
    super()
    #eventbox = Gtk::EventBox.new
    #eventbox.add(self)
    window = Gtk::Window.new(Gtk::Window::TOPLEVEL)
    window.title = title
    window.set_size_request(400, 30)
    window.transient_for=parent
    #window.add(eventbox)
    window.add(self)
    window.show_all
    window.modal = true
    window.deletable = false
    
    @window = window
 end
 
 def title=(title)
    @iteration = 0
    parent_window.title = title

    set_fraction(0)
#    if Gtk.events_pending?
#	while Gtk.main_iteration
#	end
#    end
 end
 
 def iteration()
    @iteration += 1
    set_fraction(Float(@iteration) / @length)

#    $block = true
#    while (Gtk.events_pending?)
#	puts 'new'
#	Gtk.main_iteration
#	puts 'done'
#    end
#    $block = false
 end
 
 def destroy
    @window.destroy
#    super
#    if Gtk.events_pending?
#	Gtk.main_iteration 
#    end
 end
end

class Player < Gtk::Builder
 attr_accessor :player
 
 def initialize(fps, width, height, images, real_frames)
    if images.class == Array
	@memory = true
	@images = images
	@writed  = false
    else
	@memory = false
	@images = Dir.glob(sprintf("saved_camera_images/%s/*.tif", images))
	@session = images

	pixbuf = Gdk::Pixbuf.new(@images[0])
	width = pixbuf.width
	height = pixbuf.height
	pixbuf = nil
    end

    @real_frames = real_frames

    size = @images.length * width * height / 1024 / 1024
    size = 1 if size < 1
    @size = (size < 4096)?sprintf("%i MB", size):sprintf("%i GB", (Float(size)/1024).round)
    
    @width = width
    @height = height
    @frame = 1
    @fps = fps
    @ms = 1000 / fps
    @playing = false

    super()
    
    add_from_file('player.glade')
    connect_signals { |handler| method(handler) }

    @player = get_object('player')

    if @memory then
	@player.title = sprintf("Current (%i frames, %s)", @images.length, @size)
    elsif @session =~ /^(\d{8}_\d{6})(\.(.+))?$/ then
        @player.title = sprintf("%s (%i frames, %s)", $2?$3:$1, @images.length, @size)
    else
	@player.title = sprintf("%s (%i frames, %s)", @session, @images.length, @size)
    end

    
    @area = get_object('draw')
    @area.set_gl_capability(Gdk::GLConfig.new(Gdk::GLConfig::MODE_DEPTH | Gdk::GLConfig::MODE_DOUBLE | Gdk::GLConfig::MODE_RGB))
    @area.set_size_request(width, height)
    
    Gtk::Drag.source_set(@area, 
	Gdk::Window::BUTTON1_MASK, 
	[["frame-number", Gtk::Drag::TARGET_SAME_APP, 1]],
	Gdk::DragContext::ACTION_COPY
    )

    from = get_object('from')
    to = get_object('to')

    @input_field = false
    @area.signal_connect("button-press-event") { |w, e|
	if (e.event_type == Gdk::Event::BUTTON2_PRESS) then
	    widget = @input_field?to:from
	    widget.text = sprintf("%i", @framesel.value)
	    @input_field = !@input_field
	end
    }

    [from, to].each { |widget|
	Gtk::Drag.dest_set(widget,
	    Gtk::Drag::DEST_DEFAULT_MOTION | Gtk::Drag::DEST_DEFAULT_HIGHLIGHT,
	    [["frame-number", Gtk::Drag::TARGET_SAME_APP, 1]], 
	    Gdk::DragContext::ACTION_COPY)

	widget.signal_connect("drag-drop") { |w, dc, x, y, time|
	    w.text = sprintf("%i", @framesel.value)
	}
    }

    @player.visible = true
    
    @region = Gdk::Rectangle.new(0, 0, width, height)
    
    @framesel = get_object('frame')
    @framesel.set_range(1, @images.length)
    @framesel.value = 1

    frame_value_changed_cb(@framesel)
 end

# Player window callbacks
 def frame_value_changed_cb(widget)
    @frame = widget.value
    @area.window.invalidate(@region, false)
 end
 
 def frame_format_value_cb(widget, digits)
    val = widget.value
    return @real_frames?sprintf('%i (%i)', val, @real_frames[val - 1]):sprintf('%i', val)
 end

 def play_clicked_cb(widget)
    get_object('play').sensitive = false
    @play = true
    @playing = true
    
    @frame = 1 if @frame == @images.length
    
    GLib::Timeout.add(@ms) {
	if (@play) and (@frame < @images.length) then
	    @framesel.value = @frame + 1
	    true
	else
	    get_object('play').sensitive = true
	    @playing = false
	    false
	end
    }
    
 end
 
 def forward_clicked_cb(widget)
    if (@frame < @images.length) then
	@framesel.value = @frame + 1
    else
	@framesel.value = 0
    end
 end
 
 def back_clicked_cb(widget)
    if (@frame > 0) then
	@framesel.value = @frame - 1
    else
	@framesel.value = @images.length - 1
    end
 end
 
 def pause_clicked_cb(widget)
    @play = false
 end

 def draw_expose_event_cb(area, event)
    if @memory then
	Gdk::RGB.draw_gray_image(area.window, area.style.fg_gc(area.state), 0, 0, @width, @height, Gdk::RGB::DITHER_NORMAL, @images[@frame - 1], @width)
    else
#	image = ImageList.new(@images[@frame - 1]).first
	pixbuf = Gdk::Pixbuf.new(@images[@frame - 1], @width, @height)
	@area.window.draw_pixbuf(nil, pixbuf, 0, 0, 0, 0, @width, @height, Gdk::RGB::DITHER_NORMAL, 0, 0)
    end
 end

 def save_images(name, progress)
    if @memory and not @writed then
	geometry = Magick::Geometry.new(@width, @height, nil, nil, Magick::AspectGeometry)

	time = Time.now
	basename = (name =~ /([^\/]+)\.avi$/i)?$1:name
	@session = sprintf("%02i%02i%02i_%02i%02i%02i.", time.year, time.month, time.day, time.hour, time.min, time.sec) + basename
	FileUtils::mkdir_p('saved_camera_images/' + @session)
	
	key = 0
    	@images.each { |data|
	    img = Image.from_blob(data) {
		self.format = "GRAY"
	    	self.depth = 8
		self.size = geometry
	    }[0]
		
	    key += 1	
	    img.write(sprintf("saved_camera_images/%s/PIC%09i.tif", @session, key))
	    img.destroy!

	    progress.iteration if progress
	}	 

	@writed = true
    end
 end

 def save(name = nil)
    if @memory and not @writed then
	if not name then
            fs = Gtk::Dialog.new("Please select a name", @player, Gtk::Dialog::DESTROY_WITH_PARENT,
	        [ Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL ],
		[ Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT ]
	    )

	    entry = Gtk::Entry.new	
	    fs.vbox.add(entry)
	    fs.show_all
	
	    response = fs.run
	    name = entry.text if response == Gtk::Dialog::RESPONSE_ACCEPT
	    fs.destroy
	end
	
	if name then 
    	    progress = Progress.new(@player, @images.length, sprintf("Saving %i images (%s)", @images.length, @size))
	
	    thr = Thread.start {
		save_images(name, progress)

		Gtk.main_quit
	    }
	    Gtk.main
	    thr.join
	
	    progress.destroy
	end
    end
 end
 
 def save_clicked_cb(widget)
    save
 end
 
 def video_clicked_cb(widget)
    FileUtils::mkdir_p("saved_camera_videos")

    filter = Gtk::FileFilter.new
    filter.name = "Video Files"
    filter.add_pattern('*.avi')
    
    fs = Gtk::FileChooserDialog.new("Please select a file to save", nil, Gtk::FileChooser::ACTION_SAVE, nil, 
	[ Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL ],
	[ Gtk::Stock::SAVE, Gtk::Dialog::RESPONSE_ACCEPT ]
    )
    fs.current_folder = 'saved_camera_videos'
    fs.add_filter(filter)

    response = fs.run
    name = fs.filename
    fs.destroy

    if response == Gtk::Dialog::RESPONSE_ACCEPT
	name = name + '.avi' if name !~ /\.avi$/i

	progress = Progress.new(@player, @images.length, sprintf("Saving %i images (%s)", @images.length, @size))
	
	thr = Thread.start {
	    save_images(name, progress)
	
	    FileUtils::mkdir_p("temporary_camera_images/" + @session)
	
	    progress.title = sprintf("Converting %i images (%s)", @images.length, @size)
	    
	    Dir.glob(sprintf("saved_camera_images/%s/*.tif", @session)) { |image_name|
		output = image_name.sub(/saved_camera_images/, "temporary_camera_images")
		output.sub!(/tif$/, "bmp")
	    
		image = Magick::ImageList.new(image_name)
		image.write(output)
		image.destroy!
	    
		progress.iteration
	    }
	    
	    progress.title = sprintf("Encoding %i images (%s)", @images.length, @size)
	    mplayer = open("|mencoder mf://temporary_camera_images/#{@session}/*.bmp -mf fps=#{@fps}:type=bmp -ovc x264 -x264encopts bitrate=3000 -o #{name} 2>/dev/null") { |pipe|
		pipe.each("r") { |line|
		    progress.set_fraction(Float($1)/100) if line =~ /Pos:[^(]*\(\s*(\d+)%\)/
		}
		
	    }
	    
	    progress.title = "Cleaning temporary files"
	    FileUtils::remove_dir("temporary_camera_images/" + @session)
	    
	    #system "./encode.sh \"#{name}\" \"#{@session}\" #{@fps}"
	    Gtk.main_quit
	}
	Gtk.main
	thr.join
	
	progress.destroy
    end
 end

 def cut_clicked_cb(widget)
    begin
	from = Integer(get_object('from').text)
    rescue 
	from = 0
    end
	
    begin
	to = Integer(get_object('to').text)
    rescue 
	to = @images.length - 1
    end
	
    from = 0 if (from < 0)
    to = @images.length -1 if (to <= 0) or (to >= @images.length)

    if @memory then
	Player.new(@fps, @width, @height, @images[from..to], (@real_frames)?(@real_frames[from..to]):nil)
    else
	name = nil
	
        fs = Gtk::Dialog.new("Please select a name", @player, Gtk::Dialog::DESTROY_WITH_PARENT,
	    [ Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL ],
	    [ Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT ]
	)

	entry = Gtk::Entry.new
	fs.vbox.add(entry)
	fs.show_all
	
	response = fs.run
	name = entry.text if response == Gtk::Dialog::RESPONSE_ACCEPT
	fs.destroy

	time = Time.now
	if name then
	    session = sprintf("%02i%02i%02i_%02i%02i%02i.", time.year, time.month, time.day, time.hour, time.min, time.sec) + name
	else
	    session = sprintf("%02i%02i%02i_%02i%02i%02i", time.year, time.month, time.day, time.hour, time.min, time.sec)
	end
	    
	FileUtils::mkdir_p('saved_camera_images/' + session)
	
	key = 0
	@images[from..to].each { |src|
	    key += 1
	    dst = sprintf("saved_camera_images/%s/PIC%09i.tif", session, key)
	    FileUtils::ln(src, dst)
	}
	
	Player.new(@fps, @width, @height, session, (@real_frames)?(@real_frames[from..to]):nil)
    end
 end
 
 def execute_clicked_cb(widget)
    save("matlab")

    widget.sensitive = false
    get_object("benchmark").sensitive = true
    system "LD_LIBRARY_PATH=/opt/Matlab/runtime/glnxa64/:/opt/Matlab/bin/glnxa64/:/opt/Matlab/sys/java/jre/glnxa64/jre/lib/amd64/native_threads/:/opt/Matlab/sys/java/jre/glnxa64/jre/lib/amd64/server/  ./RTCorrCode_GS \"saved_camera_images/#{@session}/PIC000000001.tif\" 1 0 &>/dev/null &"
 end

 def benchmark_clicked_cb(widget)
    widget.sensitive = false
    system "LD_LIBRARY_PATH=/opt/Matlab/runtime/glnxa64/:/opt/Matlab/bin/glnxa64/:/opt/Matlab/sys/java/jre/glnxa64/jre/lib/amd64/native_threads/:/opt/Matlab/sys/java/jre/glnxa64/jre/lib/amd64/server/  ./RTCorrCode_GS \"saved_camera_images/#{@session}/PIC000000001.tif\" 0 1 &>/dev/null &"
 end

 def kill_clicked_cb(widget)
    pause_clicked_cb(widget)
    system("killall -9 RTCorrCode_GS &> /dev/null")
    get_object("execute").sensitive = true
    get_object("benchmark").sensitive = false
 end

 def gtk_widget_delete(widget, ev)
    @play = false

    while @playing 
	Gtk.main_iteration	
    end

    # Generally we should somehow clean complete object, do it later
    @images = nil
    @real_frames = nil
    GC.start
    
#    @player.destroy

    return false
 end

 def gtk_widget_destroy(widget)
 end
end

if $*.length > 0 then
    player = Player.new(25, -1, -1, $*[0], nil)
    
    #metaclass = class << player; self; end
    #metaclass.send(:define_method, :gtk_widget_destroy) { Gtk.main_quit }
    #player.gtk_widget_destroy(nil)

    player.player.signal_connect('destroy') { Gtk.main_quit }
    Gtk.main
end
