#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>

#define read_socket "/tmp/pfserver.socket"

int main(int argc, char **argv) {
	char data[2048];
	int sock;
	int res;

	struct sockaddr_un servername;
	
	sock = socket (PF_UNIX, SOCK_STREAM, 0);

	memset(&servername, 0, sizeof(servername));
	servername.sun_family = AF_UNIX;
	strncpy(servername.sun_path,read_socket,sizeof(servername.sun_path));
	servername.sun_path[sizeof(servername.sun_path) - 1]=0;

	if (connect (sock, (struct sockaddr *) &servername, sizeof (servername)) < 0){
		fprintf(stderr, "Connection to socket is failed, error: %i\n", errno);
		exit(-1);
	}

	if (argc < 2) {
	    printf("Usage: %s <property> [value]\n", argv[0]);
	    exit(0);
	}

	if (argc > 2) {
	    res = snprintf(data, 2048, "%s %s", argv[1], argv[2]);
	    write(sock, data, res);
	} else {
	    write(sock, argv[1], strlen(argv[1]));
	}

	res = read(sock, data, 2048);
	if (res > 0) {
	    data[res] = 0;
	    puts(data);
	}
	
	close(sock);
	
	return 0;
}
