#ifndef _DSGWIDGETS
#define _DSGWIDGETS
#include <gtk/gtk.h>

/*
    DarkSoft GTK+ Widgets Library

    gds_select_file:
	File selection dialog ( returns pointer on name of file selected ),
	or NULL if cancel presset
	m:	Dialog message
    gds_select_file_without_cancel:
	File selection dialog with cancel button disabled
	m:	Dialog message
    delete_event:
	Delete event handler, which close application window and sends 
	gtk_quit to GTK application
    delete_event_reject:
	Delete event handler, which do nothing - prevents destroying
	window
    gds_are_you_sure:
	Are you sure dialog ( returns 1 if sure )
	Message: Dialog message
    gds_print_message:
	Message Box
	Message: Message to be displayed
    gds_mk_window:
	Makes window with specified context
	Box:		Window context
	Name:		Window title
	ExitFlag:	If flag is up, gtk_quit preformed then closing window
    gfd_mk_window_event:
	Signal Handler which makes window without title and which don't send
	gtk_quit event
	Box:		Window context
*/

#define gds_select_file(m) _gds_select_file((m),1)
#define gds_select_file_without_cancel(m) _gds_select_file((m),0)

#ifdef __cplusplus
extern "C" {
#endif

gint delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data);
gint delete_event_reject(GtkWidget *widget, GdkEvent  *event, gchar *str);

gchar *_gds_select_file(gchar *message, gboolean isCancel);
gboolean gds_are_you_sure(gchar *Message);
void gds_print_message(gchar *Message);
GtkWindow *gds_mk_window(GtkBox *Box, char *Name, gboolean ExitFlag);
void gds_mk_window_event(GtkWidget *Widget, GtkBox *Box);

#ifdef __cplusplus
} /* Extern "C" */
#endif

#endif /* _DSGWIDGETS */
