#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <sys/io.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <pthread.h>
#include <sched.h>

#define logfile "/var/log/namt.log"
unsigned char DaemonFlag=0;

#include "final.h"
#include "error.h"
#include "utils.h"
#include "config.h"

unsigned char ExitFlag=1;
unsigned char ExitFlagDrv=1;
unsigned long ERROR=0;
pthread_mutex_t ERROR_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t EVENT_cond = PTHREAD_COND_INITIALIZER;
pthread_mutex_t EVENT_mutex = PTHREAD_MUTEX_INITIALIZER;
int priority = 0; /* 0 - use maximal possible */

time_t final_time;

#include "disp.h"
#include "analyzer.h"
#include "buffer.h"
#include "reader.h"
#include "hilevel.h"

#include "files.h"
#include "visualize.h"

#include "cs.h"

void Stop(int n)
{
    if (!DaemonFlag) printf("Exiting...\n");
    ExitFlag=0;
}

main(int argc, char *argv[]) {
    pthread_t trd;
    pthread_attr_t atrd;
    struct sched_param ptrd;
    FILE *log;
    FILE *f;
    int err=0;
    time_t stime;
    char datestr[26];

    if ((argc<2)||(argc>3)) {
	puts("Usage: me <com port device> [daemon]");
	exit(1);
    }
    
    if ((argc>2)&&(argv[2][0]!='0')) DaemonFlag=1;

    if (!DaemonFlag) 
    	puts("Are You configure COM port with ssty?");
    
    err=ParseConfig("namt.cfg");

    if (!err) err=InitPort(argv[1]);

    if (!err) err=CSInitialise();
    
    if (!err) { 
    	pthread_attr_init(&atrd);
    	pthread_attr_setschedpolicy(&atrd,SCHED_FIFO);
    	if (!priority) priority=sched_get_priority_max(SCHED_FIFO);
    	ptrd.sched_priority=priority;
    	pthread_attr_setschedparam(&atrd, &ptrd);
    	if (pthread_create(&trd,&atrd,LoopRead,NULL)) err=ERR_PTHREAD;
	pthread_attr_destroy(&atrd);
    }
    
    if ((!err)&&(DaemonFlag)) {
	log=fopen(logfile,"a+");
	if (log) {
    	    fprintf(log,"Started at: %s\n", ctime_r(&stime,datestr));
	    fclose(log);
	}
    }
    
    signal(SIGINT,Stop);
    while ((ExitFlag)&&(!err)) {
	err=Read();
	if (!err) {
		WriteResult();
		ClientServer();
		Server();
		if (!DaemonFlag) Visualise();
	}    
    }
    ExitFlagDrv=0;

    ReleasePort();
    CSRelease();

    err|=ERROR;
    if (err) PrintError(err);
    else if (DaemonFlag) {
	log=fopen(logfile,"a+");
	if (log) {
	    fprintf(log,"Succesfully exited at: %s\n", ctime_r(&stime,datestr)); 
	    fclose(log);
	}
    }
}
