#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "files.h"
#include "files_st.h"
#include "mask.h"
#include "str.h"

/* ------------------------- Special --------------------- */
char *File::OneUp(char *path)
{
    unsigned i;
    for (i=str::strlen_(path)-1;((i>=0)&&(path[i]!='/'));i--);
    path[i]=0;
    return path;
}

char *File::MakeOneUp(char *npath, const char *path)
{
    unsigned i,j;
    for (i=str::strlen_(path)-1;((i>=0)&&(path[i]!='/'));i--);
    for (j=0;j<i;j++) npath[j]=path[j];
    npath[j]=0;
    return npath;
}
    
char *File::DeleteSlesh(char *path)
{
    int i;
    for(i=str::strlen_(path)-1;((i>=0)&&(path[i]=='/'));i--);
    path[i+1]=0; 
    return path;
}
/* --------------------- Recursive ------------------- */

unsigned File::mainr(char *src, char *dest, char level)
{
    unsigned where1, where2;
    dirent *ditem;
    DIR *dir;
    if (PrefixDir) DirFunction(src,dest,level);
    level++;
    dir=opendir(src);
    while ((ditem=readdir(dir))!=NULL)
    {
	where1=str::strlen_(src);
	str::charadd_(src,'/');
	str::stradd_(src,ditem->d_name);
	where2=str::strlen_(dest);
	str::charadd_(dest,'/');
	str::stradd_(dest,ditem->d_name);

	stat(src,&st);
	if (st.st_mode&S_IFDIR)
	{
	    if ((ditem->d_name[0]=='.')&&(ditem->d_name[1]==0)) ;
	    else if ((ditem->d_name[0]=='.')&&(ditem->d_name[1]=='.')&&(ditem->d_name[2]==0)) ;
	    else if ((UseMask&2)&&(!Mask::inMask(ditem->d_name,mask))&&((MaskLevel==0)||(MaskLevel>=level))) ;
	    else
	    {
		if (RFlag) mainr(src,dest,level);
	    }
	}
	else 
	{
	    if ((UseMask&1)&&(!Mask::inMask(ditem->d_name,mask))&&((MaskLevel==0)||(MaskLevel>=level))) ;
	    else FileFunction(src,dest,level+1);
	}
	src[where1]=0;
	dest[where2]=0;
    }
    closedir(dir);
    level--;
    if (!PrefixDir) DirFunction(src,dest,level);
}

unsigned File::r(char *src, char *dest, 
    char PrefixFlag, 
    char UMask, const char *mask_,
    char MLevel,
    char RecursiveFlag,
    unsigned (*FFunc)(const char *, const char *, char), 
    unsigned (*DFunc)(const char *,const char *, char))
{
    char stmp1[255], stmp2[255];
    unsigned err;
    str::strset_(stmp1,src);
    str::strset_(stmp2,dest);
    FileFunction=FFunc;
    DirFunction=DFunc;
    PrefixDir=PrefixFlag;
    if (mask_==NULL)
    {
	UseMask=0;
	mask[0]=0;
    }
    else
    {
	UseMask=UMask;
	str::strset_(mask,mask_);
    }
    MaskLevel=MLevel;
    RFlag=RecursiveFlag;
    DeleteSlesh(stmp1);
    DeleteSlesh(stmp2);
    if ((err=stat(stmp1,&st))!=0) return err;
    if (st.st_mode&S_IFDIR)
    {
	mainr(stmp1,stmp2,0);
    }
    else FileFunction(stmp1,stmp2,0);
    return 0;
}

unsigned File::NullItem(const char *path, const char *nop, char l)
{
    return 0;
}
/* -------------------------- ls --------------------- */
unsigned File::lsItem(const char *path, const char *nop, char l)
{
    printf("%s\n",path);
    return 0;
}

unsigned File::ls(char *path, char rflag, char *mask)
{
    return r(path,"",1,1,mask,0,rflag,&lsItem,&lsItem);
}

unsigned File::als(char *path, char PFlag, char UMask, char *mask, char RFlag, char MLevel)
{
    return r(path,"",PFlag,UMask,mask,MLevel,RFlag,&lsItem,&lsItem);
}

unsigned File::lsf(char *path, char *mask)
{
    return r(path,"",1,1,mask,0,0,&lsItem,&NullItem);
}

unsigned File::rls(char *path, char *mask)
{
    return r(path,"",1,1,mask,0,1,&lsItem,&lsItem);
}

unsigned File::rlsl(char *path, char *mask)
{
    return r(path,"",1,3,mask,1,1,&lsItem,&lsItem);
}

unsigned File::rlsf(char *path, char *mask)
{
    return r(path,"",1,1,mask,0,1,&lsItem,&NullItem);
}


/* ------------------------- rrm --------------------- */
unsigned File::rmItem(const char *path, const char *nop, char l)
{
    return remove(path);
}
unsigned File::rmdItem(const char *path, const char *nop, char l)
{
    return rmdir(path);
}

unsigned File::rm(char *path, char rflag, char *mask)
{
    return r(path,"",0,1,mask,0,rflag,&rmItem,&rmdItem);
}

unsigned File::arm(char *path, char UMask, char *mask, char RFlag, char MLevel)
{
    return r(path,"",0,UMask,mask,MLevel,RFlag,&rmItem,&rmdItem);
}

unsigned File::rmf(char *path, char *mask)
{
    return r(path,"",0,1,mask,0,0,&rmItem,&NullItem);
}

unsigned File::rrm(char *path, char *mask)
{
    return r(path,"",0,1,mask,0,1,&rmItem,&rmdItem);
}

unsigned File::rrml(char *path, char *mask)
{
    return r(path,"",0,3,mask,1,1,&rmItem,&rmdItem);
}

unsigned File::rrmf(char *path, char *mask)
{
    return r(path,"",0,1,mask,0,1,&rmItem,&NullItem);
}
/* ------------------------- Copy ---------------------- */
unsigned File::copyItem(const char *from, const char *to, char l)
{
    FILE *fi, *fo;
    unsigned long int readed;
    
    fi=fopen(from,"r");
    fo=fopen(to,"w");
    char *Buffer=new char[BufferSize];
    while ((readed=fread(Buffer,1,BufferSize,fi))>0)
	fwrite(Buffer,1,readed,fo);
    delete Buffer;
    fclose(fi);
    fclose(fo);
    return 0;
}

unsigned File::copydItem(const char *from, const char *to, char l)
{
    mkdir(to,666);
    return 0;
}

unsigned File::copy(char *from, char *to, char *mask)
{
    char stmp[255];
    unsigned err;
    MakeOneUp(stmp,to);
    if ((err=stat(stmp,&st))!=0) return err;
    if (!(st.st_mode&S_IFDIR)) return ENOTDIR;
    rrm(to);
    return r(from,to,1,1,mask,0,1,&copyItem,&copydItem);
}


unsigned File::copyi(char *from, char *to, char *mask)
{
    char stmp[255];
    unsigned err;
    unsigned i,j;
    
    i=str::strlen_(from)-1;
    while (from[i]=='/') i--;
    str::strset_(stmp,to);
    for (;((i>0)&&(from[i]!='/'));i--);
    j=str::strlen_(stmp);
    if ((stmp[j-1]!='/')&&(from[i]!='/'))
    {
	str::charadd_(stmp,'/');
	j++;
    }
    else if ((stmp[j-1]=='/')&&(from[i]=='/')) i++;
    for (;from[i]!=0;i++)
	    stmp[j++]=from[i];
    stmp[j]=0;
    return copy(from,stmp,mask);    
}

unsigned File::copyf(char *from, char *to, char rflag, char *mask)
{
    unsigned err;

    if ((err=stat(to,&st))!=0) return err;
    if (!(st.st_mode&S_IFDIR)) return ENOTDIR;
    return r(from,to,1,1,mask,0,rflag,&copyItem,&copydItem);
}

unsigned File::copyfl(char *from, char *to, char rflag, char *mask)
{
    unsigned err;

    if ((err=stat(to,&st))!=0) return err;
    if (!(st.st_mode&S_IFDIR)) return ENOTDIR;
    return r(from,to,1,3,mask,1,rflag,&copyItem,&copydItem);
}

unsigned File::acopy(char *from, char *to, char UMask, char *mask, char RFlag, char MLevel)
{
    unsigned err;
    if ((err=stat(to,&st))!=0) return err;
    if (!(st.st_mode&S_IFDIR)) return ENOTDIR;
    return r(from,to,1,UMask,mask,MLevel,RFlag,&copyItem,&copydItem);
}
