#include "mask.h"

void Mask::SkipZ(const char *str, unsigned int *i)
{
    while (str[*i]=='*') (*i)++;
}

unsigned Mask::inSymbolSub(unsigned char symbol, unsigned char mask1, unsigned char mask2)
{
    if (mask2==0)
    {
	if (symbol==mask1) return 1;
	else return 0;
    }
    else if ((symbol<=mask2)&&(symbol>=mask1)) return 1;
    else return 0;
}

unsigned Mask::inSymbol(char symbol, const char *mask)
{
    unsigned i,j;
    unsigned char submask[2];
    unsigned char StdSymbol, MaxFlag;
        
    StdSymbol=0;
    MaxFlag=0;
    j=0;submask[0]=0;submask[1]=0;
    for (i=0;mask[i]!=0;i++)
    {
	if ((mask[i]=='\\')&&(!StdSymbol)) StdSymbol=1;
	else if ((mask[i]==',')&&(!StdSymbol)) 
	{
	    if ((MaxFlag)&&(submask[1]==0)) submask[1]=255;
	    if (inSymbolSub(symbol,submask[0],submask[1])) return 1;
	    j=0;
	    MaxFlag=0;
	    submask[0]=0;submask[1]=0;
	}
	else if ((mask[i]=='-')&&(!StdSymbol))
	{
	    j++;
	    MaxFlag=1;
	}
	else
	{
	    StdSymbol=0;
	    if (submask[j]==0) submask[j]=mask[i];
	}
    }
    if ((MaxFlag)&&(submask[1]==0)) submask[1]=255;
    if (inSymbolSub(symbol,submask[0],submask[1])) return 1;
    return 0;
}
    

unsigned Mask::inMaskPart(const char *name, const char *mask, unsigned nfrom, unsigned mfrom, unsigned *nstop, unsigned *mstop)
{
    unsigned i,j,ni;
    unsigned StdSymbol; 			// After \ 
    char submask[80];
    StdSymbol=0;
    ni=nfrom;
    for (i=mfrom;((mask[i]!=0)&&(mask[i]!='*'));i++)
    {
	if (name[ni]==0) return 0;
	if ((mask[i]=='\\')&&(!StdSymbol)) StdSymbol=1;
	else if ((mask[i]=='?')&&(!StdSymbol)) ni++;
	else if ((mask[i]=='[')&&(!StdSymbol))
	{
	    i++;	  
	    for (j=0;((mask[i]!=']')||(mask[i-1]=='\\'));i++)
	    	submask[j++]=mask[i];
	    submask[j]=0;
	    if (!inSymbol(name[ni++],submask)) return 0;
	}
	else
	{
	    StdSymbol=0;
	    if (mask[i]!=name[ni++]) return 0;
	}
    }
    *nstop=ni;
    *mstop=i;
    return 1;
}
    

unsigned Mask::inMaskMain(const char *name, const char *mask, unsigned nstop, unsigned mstop)
{
    if (inMaskPart(name,mask,nstop,mstop,&nstop,&mstop)==0) return 0;
    if (mask[mstop]==0)
    {
	if (name[nstop]==0) return 1;
	else return 0;
    }
    else
    {
	SkipZ(mask,&mstop);
	if (mask[mstop]==0) return 1;
	for (unsigned i=0;name[nstop+i]!=0;i++)
	    if (inMaskMain(name,mask,nstop+i,mstop)) return 1;
    }
    return 0;
}

unsigned Mask::inMask(const char *name, const char *mask)
{
    return inMaskMain(name,mask,0,0);
}
