#include "virables.h"

void QWork::start()
{
	ChangeStatus(2);
	StopFlag=1;
	wrk=new Work(this,"data.in");
	printf("%u\n",wrk->Config->OnlyCalc);
	if (!wrk->Config->OnlyCalc) wrk->Go();
	if (wrk->Config->OnlyCalc) wrk->SaveResults();
	else wrk->SaveOutput();
	delete wrk;
	StopFlag=0;
	ChangeStatus(1);
}

void QWork::learn()
{
    char tmp[200];
    unsigned int itemp;
    FILE *f=fopen("fast.opt","r");
    fscanf(f,"%i",&itemp);
    if (itemp==0)
    {
	fclose(f);
	start();
	return;
    }
    fgets(tmp,200,f);
    fscanf(f,"%s",tmp);
    fclose(f);
    f=fopen("fast.opt","w");
    fprintf(f,"%i\n%s\n",0,tmp);
    fclose(f);
    start();
}

void QWork::control()
{
    char tmp[200];
    unsigned int itemp;
    FILE *f=fopen("fast.opt","r");
    fscanf(f,"%i",&itemp);
    if (itemp!=0)
    {
	fclose(f);
	start();
	return;
    }
    fgets(tmp,200,f);
    fscanf(f,"%s",tmp);
    fclose(f);
    f=fopen("fast.opt","w");
    fprintf(f,"%i\n%s\n",1,tmp);
    fclose(f);
    start();
}

void QWork::restart()
{
    FILE *f;
    int itemp;
    if (StopFlag) stop();
    f=fopen("fast.opt","r");
    fscanf(f,"%i",&itemp);
    fclose(f);
    f=fopen("fast.opt","w");
    fprintf(f,"%i\n0\n",itemp);
    fclose(f);
}

void QWork::stop()
{
    if (PauseFlag) pause();
    StopFlag=0;
    AutoSave();
    ChangeStatus(1);
}

void QWork::pause()
{
    if (PauseFlag) 
    {
	PauseFlag=0;
	ChangeStatus(2);
    }
    else
    {
	PauseFlag=1;
	ChangeStatus(3);
    }
}

void QWork::save()
{
    unsigned len;
    unsigned char ifPaused;
    FILE *f;

    ifPaused=PauseFlag;
    if (!ifPaused) pause();
    ChangeStatus(4);

    Save *sv=new Save(this);
    while ((ChangedFlag!=1)&&(ChangedFlag!=2))
	mm->Hell->processEvents();
    if (ChangedFlag==1)
    {
	char stmp[80]="Saves/";
	str::stradd_(stmp,sv->swe->text());
	if (mkdir(stmp,666)==EEXIST)
	{
	    File::rrm(stmp);
	    mkdir(stmp,666);
	}
	File::copyi("data.in",stmp);		// Data.in File
	File::copyi(wrk->Config->tfn,stmp);	// File with Tests
	File::copyi(wrk->Config->ncfn,stmp);	// File with Neural Configuration
	File::copyi(wrk->Config->ctfn,stmp);	// Control Samples File
	if (wrk->Config->imNNetFn[0]!=0)	// Add Initialisation file
	    File::copyi(wrk->Config->imNNetFn,stmp);

	str::charadd_(stmp,'/');		// Save NNets Values
	len=str::strlen_(stmp);
	str::stradd_(stmp,"save");
	wrk->work->NNSet->SaveNNSet(stmp,sv->swe->text());
	stmp[len]=0;

	str::stradd_(stmp,"fast.opt");		// Make fast.opt	
	f=fopen(stmp,"w");
	fprintf(f,"%u\n",wrk->Config->OnlyCalc);
	fprintf(f,"save\n");
	fclose(f);
    }
    delete sv;
    ChangedFlag=0;
    ChangeStatus(3);
    if (!ifPaused) pause();
}

void QWork::load()
{
    ChangeStatus(5);
    Load *sv=new Load(this);
    while ((ChangedFlag!=1)&&(ChangedFlag!=2))
	mm->Hell->processEvents();
    if (ChangedFlag==1)
    {
	printf("Loaduing \n",sv->swl->text(sv->swl->currentItem()));
	char stmp[80]="Saves/";
	str::stradd_(stmp,sv->swl->text(sv->swl->currentItem()));
	File::copyf(stmp,".");
    }
    delete sv;
    ChangedFlag=0;
    ChangeStatus(1);
}

void QWork::changed(unsigned int i)
{
    ChangedFlag=i;
}

QWork::QWork(QWidget *qw, MainMenu *qprg) : QProgressBar(qw)
{
    mm=qprg;
    Status=0;
    ChangedFlag=0;
}
QWork::~QWork()
{
}

void QWork::Message(unsigned char sts)
{
    FILE *f;
    char stmp[200],tmp[80];
    if (sts==1) str::strset_(stmp,"Ready!      ");
    else if (sts==2) str::strset_(stmp,"Working...  ");
    else if (sts==3) str::strset_(stmp,"Paused      ");
    else if (sts==4) str::strset_(stmp,"Saving...   ");
    else /* if (sts==5) */ str::strset_(stmp,"Loading...  ");
    f=fopen("data.in","r");
    misc::SkipComment(f);
    fscanf(f,"%s",tmp);
    fclose(f);
    str::stradd_(stmp,tmp);
    str::charadd_(stmp,' ');
    f=fopen("fast.opt","r");
    fgets(tmp,80,f);
    fscanf(f,"%s",tmp);
    fclose(f);
    if (str::strcmp_(tmp,"0")==0) str::stradd_(stmp,"New");
    else
    {
	f=fopen(tmp,"r");
	fscanf(f,"%s",tmp);
	fclose(f);
	str::stradd_(stmp,tmp);
    }
    mm->status->message(stmp);
}

void QWork::DisableEnable(unsigned char sts)
{
        if (sts==1)
	{
	    mm->qwrk->reset();
	    mm->start->setEnabled(TRUE);
	    mm->stop->setEnabled(FALSE);
	    mm->pause->setEnabled(FALSE);
	    mm->save->setEnabled(FALSE);
	    mm->load->setEnabled(TRUE);
	    mm->quit->setEnabled(TRUE);
	    mm->restart->setEnabled(TRUE);
	    mm->learn->setEnabled(TRUE);
	    mm->control->setEnabled(TRUE);
	}
        else if (sts==2)
	{
	    mm->start->setEnabled(FALSE);
	    mm->stop->setEnabled(TRUE);
	    mm->pause->setEnabled(TRUE);
	    mm->save->setEnabled(TRUE);
	    mm->load->setEnabled(FALSE);
	    mm->quit->setEnabled(FALSE);
	    mm->restart->setEnabled(TRUE);
	    mm->learn->setEnabled(FALSE);
	    mm->control->setEnabled(FALSE);
	}
        else if (sts==3)
	{
	    mm->start->setEnabled(FALSE);
	    mm->stop->setEnabled(TRUE);
	    mm->pause->setEnabled(TRUE);
	    mm->save->setEnabled(TRUE);
	    mm->load->setEnabled(FALSE);
	    mm->quit->setEnabled(FALSE);
	    mm->restart->setEnabled(TRUE);
	    mm->learn->setEnabled(FALSE);
	    mm->control->setEnabled(FALSE);
	}
        else if (sts==4)
	{
	    mm->start->setEnabled(FALSE);
	    mm->stop->setEnabled(FALSE);
	    mm->pause->setEnabled(FALSE);
	    mm->save->setEnabled(FALSE);
	    mm->load->setEnabled(FALSE);
	    mm->quit->setEnabled(FALSE);
	    mm->restart->setEnabled(FALSE);
	    mm->learn->setEnabled(FALSE);
	    mm->control->setEnabled(FALSE);
	}
        else if (sts==4)
	{
	    mm->start->setEnabled(FALSE);
	    mm->stop->setEnabled(FALSE);
	    mm->pause->setEnabled(FALSE);
	    mm->save->setEnabled(FALSE);
	    mm->load->setEnabled(FALSE);
	    mm->quit->setEnabled(FALSE);
	    mm->restart->setEnabled(FALSE);
	    mm->learn->setEnabled(FALSE);
	    mm->control->setEnabled(FALSE);
	}
}

unsigned int QWork::ChangeStatus(unsigned char sts)
{
    Status=sts;
    Message(sts);
    DisableEnable(sts);    
}

void QWork::AutoSave()
{
    FILE *f;
    int itemp;
    char tmp[200];
    
    f=fopen("fast.opt","r");
    fscanf(f,"%i",&itemp);fgets(tmp,200,f);
    fscanf(f,"%s",tmp);
    fclose(f);
    f=fopen("fast.opt","w");
    fprintf(f,"%i\nsave\n",itemp);
    fclose(f);
    if (str::strcmp_(tmp,"0")==0) str::strset_(tmp,"New");
    else
    {
	f=fopen(tmp,"r");
	fscanf(f,"%s",tmp);
	fclose(f);
    }
    str::stradd_(tmp," (AutoSaved)");
    wrk->work->NNSet->SaveNNSet("save", tmp);
}
