#include "stdafx.h"
#include "virables.h"

UINT cdmsgShareViolation = 0;  // identifier from RegisterWindowMessage
UINT cdmsgFileOK         = 0;  // identifier from RegisterWindowMessage
UINT cdmsgHelp           = 0;  // identifier from RegisterWindowMessage
const char szmsgSHAREVIOLATION[] = SHAREVISTRING;  // string for sharing violation
const char szmsgFILEOK[]         = FILEOKSTRING;   // string for OK button
const char szCommdlgHelp[]       = HELPMSGSTRING;  // string for Help button

AVI::AVI(HWND hwnd, HINSTANCE hinst)
{
	OPENFILENAME OpenFileName;
	struct TFileSelected
	{
		char name[80];		// a test buffer containing the file selected
		char path[80];       // a test buffer containing the file path
	} FileSelected; 

	hWnd=hwnd;
	hInst=hinst;
	szFile[0]=0;

	// Fill in the OPENFILENAME structure to support a template and hook.
	OpenFileName.lStructSize       = sizeof(OPENFILENAME);
    OpenFileName.hwndOwner         = hWnd;
    OpenFileName.hInstance         = hInst;
    OpenFileName.lpstrFilter       = NULL;
    OpenFileName.lpstrCustomFilter = NULL;
    OpenFileName.nMaxCustFilter    = 0;
    OpenFileName.nFilterIndex      = 0;
    OpenFileName.lpstrFile         = szFile;
    OpenFileName.nMaxFile          = sizeof(szFile);
    OpenFileName.lpstrFileTitle    = NULL;
    OpenFileName.nMaxFileTitle     = 0;
    OpenFileName.lpstrInitialDir   = NULL;
    OpenFileName.lpstrTitle        = "Open a File";
    OpenFileName.nFileOffset       = 0;
    OpenFileName.nFileExtension    = 0;
    OpenFileName.lpstrDefExt       = NULL;
	OpenFileName.lCustData         = (LPARAM)&FileSelected;
	OpenFileName.lpfnHook 		   = (LPOFNHOOKPROC)Load;
	OpenFileName.lpTemplateName    = MAKEINTRESOURCE(IDD_Load);
    OpenFileName.Flags             = OFN_SHOWHELP | OFN_EXPLORER | OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;

    if (GetOpenFileName(&OpenFileName))
    {
		PostMessage(hWnd,WM_COMMAND,IDM_Start,0);
    }
}

void AVI::Init()
{
	cdmsgShareViolation = RegisterWindowMessage(szmsgSHAREVIOLATION);
    cdmsgFileOK         = RegisterWindowMessage(szmsgFILEOK);
    cdmsgHelp           = RegisterWindowMessage(szCommdlgHelp);
	
	Size=SizeX*SizeY;

	SFirst=new WORD[Zoom*Zoom];
	SCur=new WORD[Zoom*Zoom];
	Buffer=new unsigned char[Size];

	hdc = GetDC(hWnd);
	memDCY=CreateCompatibleDC(hdc);
	hbmpY=LoadBitmap(hInst, (LPCTSTR)IDB_YELLOW);
	memDCR=CreateCompatibleDC(hdc);
	hbmpR=LoadBitmap(hInst, (LPCTSTR)IDB_RED);
	memDCG=CreateCompatibleDC(hdc);
	hbmpG=LoadBitmap(hInst, (LPCTSTR)IDB_GREEN);
	SelectObject(memDCY,hbmpY);
	SelectObject(memDCR,hbmpR);
	SelectObject(memDCG,hbmpG);

	fres=fopen("out.txt","w");	
	
	mid=0;
	State=0;
	State2=0;
	DarkC=0.75;
	UDarkC=0.6;
}

AVI::~AVI()
{
	if (szFile[0]!=0)
	{
		DeleteObject(hbmpY);
		DeleteObject(hbmpR);
		DeleteObject(hbmpG);
		ReleaseDC(hWnd,hdc);
		DeleteDC(memDCY);
		DeleteDC(memDCR);
		DeleteDC(memDCG);
		fclose(fres);
		delete SFirst;
		delete SCur;
		delete Buffer;
	}
}

void AVI::StartAVI()
{
	if (!GoAVI("yes.avi",1)) return;
	if (!GoAVI("no.avi",2)) return;
	MakeC();
	GoAVI(szFile,0);
}

BOOL AVI::GoAVI(TCHAR *fname, BYTE Doing)
{
	DWORD temp,b1,b2;
	DWORD i,l=0;
	DWORD FSize,CurPtr,Ptr;
	FILE *f;

	f=fopen(fname,"r");
	fread(&temp,4,1,f);
	if (temp!=0x46464952)
	{
		fclose(f);
		szFile[0]=0;
		if (Doing==1) MessageBox(hWnd,"Can't find or invalid file <yes.avi>!",NULL, MB_OK);	
		else if (Doing==2) MessageBox(hWnd,"Can't find or invalid file <no.avi>!",NULL, MB_OK);	
		else MessageBox(hWnd,"It's not AVI File!",NULL, MB_OK);	
		return(FALSE);
	}
	fread(&FSize,4,1,f);
	fseek(f,0x40,SEEK_SET);
	fread(&SizeX,4,1,f);
	fread(&SizeY,4,1,f);
	if (Doing==1) Init();

	fseek(f,FSize,SEEK_SET);
	fread(&Ptr,4,1,f);
	CurPtr=FSize-0x10;

	BitBlt(hdc,SizeX+50,0,30,100,memDCY,0,0,SRCCOPY);

	MaxSum=0;
	while (Ptr!=0x31786469)  // idx1
	{
		fseek(f,CurPtr,SEEK_SET);
		fread(&Ptr,4,1,f);
		CurPtr-=0x10;
		l++;
	}
	CurPtr+=0x20;
	fseek(f,CurPtr-8,SEEK_SET);
	fread(&b1,4,1,f);
	fread(&b2,4,1,f);
	fread(&Ptr,4,1,f);
	fread(&temp,4,1,f);
	for(i=0;i<=l;i++)
	{
		if ((temp!=0x3FF8)&&(b1==0x62643030)&&(b2==0x10))
		{
			fseek(f,Ptr+0x8,SEEK_SET);
			if (Doing==0) DrawAVI(f,i);
			else ReadC(f,Doing);
		}
		fseek(f,CurPtr-8,SEEK_SET);
		fread(&b1,4,1,f);
		fread(&b2,4,1,f);
		fread(&Ptr,4,1,f);
		fread(&temp,4,1,f);
		CurPtr+=0x10;
	}
	fclose(f);
	return TRUE;
}

void AVI::MakeC()
{
	XMid=(XMaxYes+4*XMaxNo)/5;
	XYMid=(XYMaxYes+9*XYMaxNo)/10;
//	XMidS=XMaxNo/(1.*XMaxYes/XMaxNo);
//	XYMidS=1+XYMaxNo/(XYMaxYes/XYMaxNo);
	XMidS=XMaxNo/2;
//	XYMidS=XYMaxNo/2;
}

void AVI::ReadC(FILE *f, BYTE Doing)
{
	fread(Buffer,1,Size,f);
	GetMiddle();
	AnalyzeAVI(Doing);
	if (Sum>MaxSum)
	{
		MaxSum=Sum;
		if (Doing==1)
		{
			XMaxYes=XMax;
			XYMaxYes=XYMax;
		}
		else
		{
			XMaxNo=XMax;
			XYMaxNo=XYMax;
		}
	}
	mid=0;
}


void AVI::DrawAVI(FILE *f, DWORD kadr)
{
	unsigned i,j,l=0;
	BYTE c;
	fread(Buffer,1,Size,f);
	for (i=0;i<SizeY;i++)
		for (j=0;j<SizeX;j++)
		{
			//SetPixel(hdc,j,SizeY-i,PALETTERGB(0xff-Buffer[l],0xff-Buffer[l],0xff-Buffer[l]));
			//l++;
			c=GetXY(j,i);
			SetPixel(hdc,j,i,PALETTERGB(c,c,c));
		}
	GetMiddle();
	if (kadr==0)
	{
		AnalyzeAVI(65535);
		while (XMax>XMidS/3)
		{
			UDarkC-=0.015;
			AnalyzeAVI(65535);
		};
		while (XMax<2)
		{
			UDarkC+=0.015;
			AnalyzeAVI(65535);
		}
	}

	AnalyzeAVI(kadr);
	Choose();
}

BYTE AVI::ChooseYesNo(WORD XMax, double XYMax)
{
	if (((XYMax-XYMid)/(XYMaxYes-XYMaxNo)+(XMax-XMid)/(XMaxYes-XMaxNo))<0)
		return 2;
	else return 1;
}

void AVI::Choose()
{
	if (XMax<XMidS)
	{
		if (State2>1)
		{
			if (State>0)
			{
				if (State>2) 
				{
					if (ChooseYesNo(XMaxC,XYMaxC)==1) fprintf(fres,"Yes\n");
					else fprintf(fres,"No\n");
				}
				State=0;
			}
			State2=0;
		}
		else State2++;
	}
	else
	{
		if (State>0)
		{
			State++;
			if (Sum>MaxSum)
			{
				MaxSum=Sum;
				XMaxC=XMax;
				XYMaxC=XYMax;
			}
		}
		else
		{
			State=1;
			MaxSum=Sum;
			XMaxC=XMax;
			XYMaxC=XYMax;
		}
	}
}

BYTE AVI::GetXY(DWORD x, DWORD y)
{
	return 0xff-Buffer[(SizeY-y-1)*SizeX+x];
}

BYTE AVI::GetMiddle()
{
	DWORD sum=0;
	if (mid==0)
	{
		for (unsigned i=0;i<Size;i++)
			sum+=0xff-Buffer[i];
		mid=sum/Size;
	}
	return mid;
}

DWORD AVI::GetSumColor(DWORD x, DWORD y, DWORD Size)
{
	DWORD Sum;
	for (unsigned i=x;((i<x+Size)&&(i<SizeX));i++)
		for (unsigned j=y;((j<y+Size)&&(j<SizeY));j++)
			Sum+=GetXY(i,j);
	return Sum;
}	

BYTE AVI::GetFragment(DWORD x, DWORD y, DWORD Size)
{
	return GetSumColor(x,y,Size)/(Size*Size);
}


void AVI::AnalyzeAVI(DWORD kadr)
{
	BYTE Dark=(int)(mid*DarkC);
	BYTE UltraDark=(int)(mid*UDarkC);
	BYTE c;
	BYTE Zero3,Zero2,Before;
	WORD Long1,Long2;
	WORD Max;
	unsigned x,y;

//	GetMoved(Buffer,SizeX,SizeY,kadr);
/*	if (kadr==0)
	{
		FILE *f=fopen("1.txt","w");
		for (y=0;y<SizeY;y++)
		{
			for (x=0;x<SizeX;x++)
			{
				c=GetXY(x,y);
				if (c<UltraDark) fprintf(f,"2");
				else if (c<Dark) fprintf(f,"1");
				else fprintf(f,"0");
			}
			fprintf(f,"\n");
		}
		fclose(f);
		exit(0);
	}*/

	Max=0;
	for (y=0;y<SizeY;y++)
	{
		Long1=0;Long2=0;Zero3=0;Before=mid;Zero2=0;
		if (y==78)
		{
			Long1=0;
		}
		for (x=0;x<SizeX;x++)
		{
			Before=c;
			c=GetXY(x,y);
			if (c<UltraDark)
			{
				if (Long2==0)
				{
					if (Zero3>=0) Long2++;
				}
				else 
				{
					if (Before<UltraDark) Long2++;
					else 
					{
						Long1+=Long2;
						Long2=Zero3+Zero2+1;
					}
				}
				Zero3=0;
				Zero2=0;
			}
			else if (c<Dark) 
			{
				Zero2+=Zero3+1;
				Zero3=0;
			}
			else Zero3++;
		}
		if (Zero3>=0) Long1+=Long2;
		if (Long1>Max) Max=Long1;
	}
	if ((debug)&&(kadr<65535)) fprintf(fres,"%u ",Max);
	XMax=Max;
	Max=0;
	Sum=0;
	for (x=0;x<SizeX;x++)
	{
		Long1=0;Long2=0;Zero2=0;Before=mid;
		for (y=0;y<SizeY;y++)
		{

			Before=c;
			c=GetXY(x,y);
			if (c<UltraDark)
			{
				if (Before<UltraDark) Long2++;
				else 
				{
					if (Long2==0) Zero2=0;
					Long1+=Long2;
					Long2=Zero2+1;
				}
				Zero2=0;
				Sum+=2;
			}
			else if (c<Dark) 
			{
				Zero2++;
				Sum++;
			}
			else 
			{
				Long1+=Long2;
				Zero2=0;
				if (Long1>Max) Max=Long1;
				Long1=0;
				Long2=0;
			}
		}
		Long1+=Long2;
		if (Long1>Max) Max=Long1;
	}
	XYMax=(1.*XMax)/Max;
	if ((debug)&&(kadr<65535)) fprintf(fres,"%u ",Max);
	if ((debug)&&(kadr<65535)) fprintf(fres,"%u %u\n",Sum,kadr);
}

LRESULT CALLBACK Load(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{

	switch (message)
	{
		case WM_INITDIALOG:
			// Save off the long pointer to the OPENFILENAME structure.
			SetWindowLong(hDlg, DWL_USER, lParam);
			break;
		default:
			if (message == cdmsgFileOK)
			{
				break;
			}
			else if (message == cdmsgShareViolation)
			{
				MessageBox(hDlg, "Got a sharing violation message.", "ComDlg32 Test", MB_OK);
				break;
			}
			return FALSE;
	}
	return TRUE;
}
